<?php
// 包含数据库和笔记类文件
require_once 'note.php';
require_once 'auth.php'; // 添加身份验证

// 检查ID参数
if(!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: index.php");
    exit;
}

// 创建笔记对象
$note = new Note();
$note->id = $_GET['id'];

// 获取笔记详情
if(!$note->readOne()) {
    header("Location: index.php?error=笔记不存在");
    exit;
}

// 获取笔记的图片
$images = $note->getImages();
?>

<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($note->title); ?> - 在线记事本</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f5f5;
            color: #333;
            line-height: 1.6;
            padding: 20px;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #ddd;
        }
        h1 {
            font-size: 24px;
            color: #333;
        }
        .btn {
            display: inline-block;
            padding: 8px 16px;
            background-color: #4CAF50;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            font-size: 14px;
            transition: background-color 0.3s;
        }
        .btn:hover {
            background-color: #45a049;
        }
        .btn-outline {
            background-color: transparent;
            border: 1px solid #4CAF50;
            color: #4CAF50;
        }
        .btn-outline:hover {
            background-color: #4CAF50;
            color: white;
        }
        .btn-danger {
            background-color: #f44336;
        }
        .btn-danger:hover {
            background-color: #d32f2f;
        }
        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            padding: 20px;
            margin-bottom: 20px;
        }
        .note-meta {
            color: #777;
            font-size: 14px;
            margin-bottom: 15px;
        }
        .note-content {
            white-space: pre-line;
            margin-bottom: 20px;
            line-height: 1.8;
        }
        .image-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }
        .image-item {
            position: relative;
            aspect-ratio: 1;
            border-radius: 8px;
            overflow: hidden;
        }
        .note-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s;
            cursor: pointer;
        }
        .note-image:hover {
            transform: scale(1.05);
        }
        .action-buttons {
            display: flex;
            gap: 10px;
            margin-top: 20px;
        }
        
        /* Modal styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 100;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.7);
            overflow: auto;
        }
        .modal-content {
            position: relative;
            background-color: #fefefe;
            margin: 10% auto;
            padding: 20px;
            width: 80%;
            max-width: 800px;
            border-radius: 8px;
        }
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
            margin-bottom: 15px;
        }
        .modal-title {
            font-size: 18px;
            font-weight: bold;
        }
        .modal-body {
            text-align: center;
        }
        .modal-img {
            max-width: 100%;
            max-height: 70vh;
            border-radius: 4px;
        }
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        .close:hover {
            color: #333;
        }
        @media (max-width: 768px) {
            .header {
                flex-direction: column;
                align-items: start;
                gap: 10px;
            }
            .image-grid {
                grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
            }
            .modal-content {
                width: 95%;
                margin: 5% auto;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><?php echo htmlspecialchars($note->title); ?></h1>
            <a href="index.php" class="btn btn-outline">返回列表</a>
        </div>
        
        <div class="card">
            <div class="note-meta">
                <div>创建于：<?php echo date("Y-m-d H:i", strtotime($note->created_at)); ?></div>
                <?php if($note->updated_at != $note->created_at): ?>
                    <div>更新于：<?php echo date("Y-m-d H:i", strtotime($note->updated_at)); ?></div>
                <?php endif; ?>
            </div>
            
            <div class="note-content">
                <?php echo nl2br(htmlspecialchars($note->content)); ?>
            </div>
            
            <?php if($images && $images->rowCount() > 0): ?>
                <h3>附件图片</h3>
                <div class="image-grid">
                    <?php while($img = $images->fetch(PDO::FETCH_ASSOC)): ?>
                        <div class="image-item">
                            <img src="<?php echo htmlspecialchars($img['image_path']); ?>" 
                                 class="note-image" 
                                 alt="附件图片" 
                                 onclick="showImage('<?php echo htmlspecialchars($img['image_path']); ?>')">
                        </div>
                    <?php endwhile; ?>
                </div>
            <?php endif; ?>
            
            <div class="action-buttons">
                <a href="edit.php?id=<?php echo $note->id; ?>" class="btn">
                    编辑笔记
                </a>
                <a href="delete.php?id=<?php echo $note->id; ?>" class="btn btn-danger" 
                   onclick="return confirm('确定删除这条笔记吗？')">
                    删除笔记
                </a>
            </div>
        </div>
    </div>
    
    <!-- 图片查看模态框 -->
    <div id="imageModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <span class="modal-title">查看图片</span>
                <span class="close" onclick="closeModal()">&times;</span>
            </div>
            <div class="modal-body">
                <img id="modalImage" src="" class="modal-img" alt="大图">
            </div>
        </div>
    </div>
    
    <script>
        // 显示图片模态框
        function showImage(src) {
            const modal = document.getElementById('imageModal');
            const modalImg = document.getElementById('modalImage');
            modal.style.display = "block";
            modalImg.src = src;
        }
        
        // 关闭模态框
        function closeModal() {
            document.getElementById('imageModal').style.display = "none";
        }
        
        // 点击模态框外部关闭
        window.onclick = function(event) {
            const modal = document.getElementById('imageModal');
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }
    </script>
</body>
</html> 