<?php
// 引入数据库配置文件
require_once 'dbconfig.php';

// 创建数据库连接
try {
    $conn = new PDO("mysql:host=".DB_HOST.";port=".DB_PORT.";dbname=".DB_NAME, DB_USER, DB_PASS);
    // 设置PDO错误模式为异常
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // 尝试删除之前可能存在的表（如果有）以避免外键冲突
    try {
        $sql = "DROP TABLE IF EXISTS images";
        $conn->exec($sql);
        
        $sql = "DROP TABLE IF EXISTS notes";
        $conn->exec($sql);
    } catch(PDOException $e) {
        // 忽略删除表错误
    }
    
    // 创建notes表 - 使用普通的DATETIME类型，不使用触发器
    $sql = "CREATE TABLE IF NOT EXISTS notes (
        id INT(11) AUTO_INCREMENT PRIMARY KEY,
        title VARCHAR(255) NOT NULL,
        content TEXT NOT NULL,
        created_at DATETIME NOT NULL,
        updated_at DATETIME NOT NULL
    )";
    $conn->exec($sql);
    
    // 创建images表
    $sql = "CREATE TABLE IF NOT EXISTS images (
        id INT(11) AUTO_INCREMENT PRIMARY KEY,
        note_id INT(11) NOT NULL,
        image_path VARCHAR(255) NOT NULL,
        created_at DATETIME NOT NULL,
        FOREIGN KEY (note_id) REFERENCES notes(id) ON DELETE CASCADE
    )";
    $conn->exec($sql);
    
    echo "数据库表创建成功！现在您可以使用记事本应用了。";
} catch(PDOException $e) {
    echo "数据库错误: " . $e->getMessage();
}

// 关闭连接
$conn = null;
?> 