<?php
// 包含数据库和笔记类文件
require_once 'note.php';
require_once 'password_config.php';

// 检查用户是否已登录
if (!is_authenticated()) {
    // 保存当前尝试访问的URL
    $_SESSION['redirect_url'] = $_SERVER['REQUEST_URI'];
    header('Location: login.php');
    exit;
}

// 创建笔记对象
$note = new Note();

// 获取所有笔记
$stmt = $note->readAll();
?>

<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>在线记事本</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f5f5;
            color: #333;
            line-height: 1.6;
            padding: 20px;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #ddd;
        }
        h1 {
            font-size: 24px;
            color: #333;
        }
        .btn {
            display: inline-block;
            padding: 8px 16px;
            background-color: #4CAF50;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            font-size: 14px;
            transition: background-color 0.3s;
        }
        .btn:hover {
            background-color: #45a049;
        }
        .btn-outline {
            background-color: transparent;
            border: 1px solid #4CAF50;
            color: #4CAF50;
        }
        .btn-outline:hover {
            background-color: #4CAF50;
            color: white;
        }
        .btn-danger {
            background-color: #f44336;
        }
        .btn-danger:hover {
            background-color: #d32f2f;
        }
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
        }
        .alert-success {
            background-color: #dff0d8;
            color: #3c763d;
            border: 1px solid #d6e9c6;
        }
        .alert-info {
            background-color: #d9edf7;
            color: #31708f;
            border: 1px solid #bce8f1;
        }
        .grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
        }
        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            padding: 20px;
            transition: all 0.3s ease;
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .card-title {
            font-size: 18px;
            margin-bottom: 10px;
        }
        .card-subtitle {
            font-size: 14px;
            color: #777;
            margin-bottom: 15px;
        }
        .card-content {
            max-height: 100px;
            overflow: hidden;
            text-overflow: ellipsis;
            margin-bottom: 15px;
        }
        .card-images {
            display: flex;
            overflow-x: auto;
            margin: 10px 0;
            gap: 10px;
        }
        .card-image {
            width: 80px;
            height: 80px;
            object-fit: cover;
            border-radius: 5px;
        }
        .card-actions {
            display: flex;
            gap: 8px;
            margin-top: 15px;
        }
        .btn-sm {
            padding: 5px 10px;
            font-size: 13px;
        }
        .close-btn {
            float: right;
            font-size: 20px;
            font-weight: bold;
            cursor: pointer;
        }
        @media (max-width: 768px) {
            .grid {
                grid-template-columns: 1fr;
            }
            .header {
                flex-direction: column;
                align-items: start;
                gap: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>我的记事本</h1>
            <div>
                <a href="create.php" class="btn">新建笔记</a>
                <a href="change_password.php" class="btn btn-outline" style="margin-left: 10px;">修改密码</a>
                <a href="logout.php" class="btn btn-danger" style="margin-left: 10px;">退出登录</a>
            </div>
        </div>
        
        <?php if (isset($_GET['success'])): ?>
            <div class="alert alert-success">
                <?php echo htmlspecialchars($_GET['success']); ?>
                <span class="close-btn" onclick="this.parentElement.style.display='none'">&times;</span>
            </div>
        <?php endif; ?>
        
        <div class="grid">
            <?php 
            if($stmt && $stmt->rowCount() > 0) {
                while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    extract($row);
                    
                    // 获取笔记的图片
                    $note->id = $id;
                    $images = $note->getImages();
                    
                    echo '<div class="card">';
                    echo '  <h3 class="card-title">' . htmlspecialchars($title) . '</h3>';
                    echo '  <div class="card-subtitle">' . date("Y-m-d H:i", strtotime($created_at)) . '</div>';
                    echo '  <div class="card-content">' . nl2br(htmlspecialchars($content)) . '</div>';
                    
                    // 显示图片缩略图
                    if($images && $images->rowCount() > 0) {
                        echo '  <div class="card-images">';
                        while($img = $images->fetch(PDO::FETCH_ASSOC)) {
                            echo '  <img src="' . htmlspecialchars($img['image_path']) . '" class="card-image" alt="附件图片">';
                        }
                        echo '  </div>';
                    }
                    
                    echo '  <div class="card-actions">';
                    echo '      <a href="view.php?id=' . $id . '" class="btn btn-sm">查看</a>';
                    echo '      <a href="edit.php?id=' . $id . '" class="btn btn-sm btn-outline">编辑</a>';
                    echo '      <a href="delete.php?id=' . $id . '" class="btn btn-sm btn-danger" onclick="return confirm(\'确定删除这条笔记吗？\')">删除</a>';
                    echo '  </div>';
                    echo '</div>';
                }
            } else {
                echo '<div class="alert alert-info">暂无笔记，点击右上角"新建笔记"按钮创建您的第一条笔记。</div>';
            }
            ?>
        </div>
    </div>
    
    <script>
        // 简单的关闭提示框功能
        document.addEventListener('DOMContentLoaded', function() {
            const closeButtons = document.querySelectorAll('.close-btn');
            closeButtons.forEach(function(button) {
                button.addEventListener('click', function() {
                    this.parentElement.style.display = 'none';
                });
            });
        });
    </script>
</body>
</html> 