<?php
// 包含数据库和笔记类文件
require_once 'note.php';
require_once 'auth.php'; // 添加身份验证

// 检查ID参数
if(!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: index.php");
    exit;
}

// 创建笔记对象
$note = new Note();
$note->id = $_GET['id'];

// 获取笔记详情（检查是否存在）
if(!$note->readOne()) {
    header("Location: index.php?error=笔记不存在");
    exit;
}

// 删除笔记
if($note->delete()) {
    header("Location: index.php?success=笔记已成功删除");
} else {
    header("Location: view.php?id=" . $note->id . "&error=删除笔记失败，请稍后重试");
}
exit; 