<?php
// 包含数据库和笔记类文件
require_once 'note.php';
require_once 'auth.php'; // 添加身份验证

// 创建笔记对象
$note = new Note();

// 处理表单提交
if($_SERVER["REQUEST_METHOD"] == "POST") {
    // 设置笔记属性
    $note->title = $_POST['title'];
    $note->content = $_POST['content'];
    
    // 创建笔记
    $note_id = $note->create();
    
    if($note_id) {
        // 处理图片上传
        $upload_dir = "uploads/";
        
        // 创建上传目录（如果不存在）
        if(!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }
        
        // 处理多个图片上传
        if(isset($_FILES['images']) && !empty($_FILES['images']['name'][0])) {
            $total_files = count($_FILES['images']['name']);
            
            for($i = 0; $i < $total_files; $i++) {
                // 检查文件上传是否成功
                if($_FILES['images']['error'][$i] == 0) {
                    $temp_name = $_FILES['images']['tmp_name'][$i];
                    $file_name = $_FILES['images']['name'][$i];
                    
                    // 生成唯一文件名
                    $new_file_name = $upload_dir . uniqid() . '_' . basename($file_name);
                    
                    // 检查文件类型
                    $allowed_types = array('image/jpeg', 'image/png', 'image/gif');
                    $file_type = $_FILES['images']['type'][$i];
                    
                    if(in_array($file_type, $allowed_types)) {
                        // 移动上传的文件
                        if(move_uploaded_file($temp_name, $new_file_name)) {
                            // 保存图片路径到数据库
                            $note->saveImage($note_id, $new_file_name);
                        }
                    }
                }
            }
        }
        
        // 重定向到首页
        header("Location: index.php?success=笔记创建成功");
        exit;
    } else {
        $error_message = "创建笔记失败，请稍后重试";
    }
}
?>

<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>新建笔记 - 在线记事本</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f5f5;
            color: #333;
            line-height: 1.6;
            padding: 20px;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #ddd;
        }
        h1 {
            font-size: 24px;
            color: #333;
        }
        .btn {
            display: inline-block;
            padding: 8px 16px;
            background-color: #4CAF50;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            font-size: 14px;
            transition: background-color 0.3s;
            border: none;
            cursor: pointer;
        }
        .btn:hover {
            background-color: #45a049;
        }
        .btn-outline {
            background-color: transparent;
            border: 1px solid #4CAF50;
            color: #4CAF50;
        }
        .btn-outline:hover {
            background-color: #4CAF50;
            color: white;
        }
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
        }
        .alert-danger {
            background-color: #f2dede;
            color: #a94442;
            border: 1px solid #ebccd1;
        }
        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            padding: 20px;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
        }
        .form-control {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
            font-family: inherit;
        }
        .form-text {
            font-size: 14px;
            color: #777;
            margin-top: 5px;
        }
        textarea.form-control {
            min-height: 150px;
            resize: vertical;
        }
        .preview-image {
            max-width: 150px;
            max-height: 150px;
            margin-right: 10px;
            margin-bottom: 10px;
            border-radius: 5px;
            object-fit: cover;
        }
        .image-preview {
            display: flex;
            flex-wrap: wrap;
            margin-top: 10px;
        }
        .close-btn {
            float: right;
            font-size: 20px;
            font-weight: bold;
            cursor: pointer;
        }
        @media (max-width: 768px) {
            .header {
                flex-direction: column;
                align-items: start;
                gap: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>新建笔记</h1>
            <a href="index.php" class="btn btn-outline">返回列表</a>
        </div>
        
        <?php if (isset($error_message)): ?>
            <div class="alert alert-danger">
                <?php echo $error_message; ?>
                <span class="close-btn" onclick="this.parentElement.style.display='none'">&times;</span>
            </div>
        <?php endif; ?>
        
        <div class="card">
            <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="title" class="form-label">标题</label>
                    <input type="text" class="form-control" id="title" name="title" required>
                </div>
                
                <div class="form-group">
                    <label for="content" class="form-label">内容</label>
                    <textarea class="form-control" id="content" name="content" rows="6" required></textarea>
                </div>
                
                <div class="form-group">
                    <label for="images" class="form-label">上传图片（可选，支持多张）</label>
                    <input type="file" class="form-control" id="images" name="images[]" multiple accept="image/*">
                    <div class="form-text">支持JPG、PNG和GIF格式，可同时上传多张图片</div>
                    <div id="imagePreview" class="image-preview"></div>
                </div>
                
                <button type="submit" class="btn">保存笔记</button>
            </form>
        </div>
    </div>
    
    <script>
        // 图片预览功能
        document.getElementById('images').addEventListener('change', function(event) {
            const preview = document.getElementById('imagePreview');
            preview.innerHTML = '';
            
            for (let i = 0; i < event.target.files.length; i++) {
                const file = event.target.files[i];
                if (!file.type.startsWith('image/')) continue;
                
                const img = document.createElement('img');
                img.classList.add('preview-image');
                img.file = file;
                preview.appendChild(img);
                
                const reader = new FileReader();
                reader.onload = (function(aImg) { 
                    return function(e) { 
                        aImg.src = e.target.result; 
                    }; 
                })(img);
                reader.readAsDataURL(file);
            }
        });
        
        // 关闭提示框功能
        document.addEventListener('DOMContentLoaded', function() {
            const closeButtons = document.querySelectorAll('.close-btn');
            closeButtons.forEach(function(button) {
                button.addEventListener('click', function() {
                    this.parentElement.style.display = 'none';
                });
            });
        });
    </script>
</body>
</html> 