# PHP在线记事本

这是一个基于PHP和MySQL的简单在线记事本应用，支持上传和管理图片，具有密码保护功能。

## 功能特点

- 创建、编辑、查看和删除笔记
- 支持为每个笔记上传多张图片
- 响应式设计，适配移动端和桌面端
- 图片预览和大图查看功能
- 密码保护功能，防止未授权访问
- 支持修改访问密码

## 安装部署

### 环境要求

- PHP 7.0 或更高版本
- MySQL 5.6 或更高版本
- 启用PDO和PDO_MySQL扩展

### 安装步骤

1. 将所有文件上传到您的Web服务器目录中
2. 确保您的Web服务器对`uploads`目录有写入权限
3. 在MySQL中创建一个新数据库
4. 修改`dbconfig.php`中的数据库连接信息
5. 在浏览器中访问`setup.php`创建必要的数据库表
6. 删除或重命名`setup.php`以提高安全性
7. 访问`index.php`开始使用记事本，默认密码为`admin123`

```php
// 示例dbconfig.php配置
define('DB_HOST', 'localhost'); // 数据库主机
define('DB_PORT', '3306');      // 数据库端口
define('DB_NAME', 'notebook');  // 数据库名称
define('DB_USER', 'username');  // 数据库用户名
define('DB_PASS', 'password');  // 数据库密码
```

## 文件结构

- `index.php` - 主页，显示所有笔记列表
- `create.php` - 创建新笔记
- `view.php` - 查看笔记详情
- `edit.php` - 编辑现有笔记
- `delete.php` - 删除笔记
- `note.php` - 笔记类，处理笔记相关的操作
- `db.php` - 数据库连接类
- `dbconfig.php` - 数据库配置信息
- `setup.php` - 数据库初始化脚本
- `password_config.php` - 密码配置文件
- `login.php` - 登录页面
- `logout.php` - 退出登录
- `change_password.php` - 修改密码页面
- `auth.php` - 身份验证处理
- `uploads/` - 存储上传的图片

## 使用方法

1. 首次访问时需要输入密码（默认密码为`admin123`）
2. 登录后可以查看所有笔记
3. 点击"新建笔记"按钮创建笔记
4. 填写笔记标题和内容，可选择上传一张或多张图片
5. 在笔记列表中，可以查看、编辑或删除每条笔记
6. 查看笔记详情时，点击图片可以查看大图
7. 点击"修改密码"可以更改访问密码
8. 点击"退出登录"可以安全退出系统

## 安全注意事项

- 在生产环境中部署前，请确保更改默认的数据库凭据和访问密码
- 为提高安全性，建议在初始化数据库后删除或禁止访问`setup.php`
- 定期备份数据库以防数据丢失
- 密码使用MD5加密存储，建议使用强密码提高安全性

## 已知问题和限制

- 目前仅支持JPG、PNG和GIF格式的图片
- 没有多用户系统，只有单一的密码保护
- 没有富文本编辑功能，仅支持纯文本 